% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Sunspot}
\alias{Sunspot}
\title{Wolfer sunspot numbers from 1700 through 2000}
\format{
A data frame/tibble with 301 observations on two variables
\describe{ 
\item{year}{year} 
\item{sunspots}{average number of sunspots for the year} 
}
}
\usage{
Sunspot
}
\description{
Data for Example 1.7
}
\examples{

plot(sunspots ~ year, data = Sunspot, type = "l")
\dontrun{
library(ggplot2)
lattice::xyplot(sunspots ~ year, data = Sunspot, 
                main = "Yearly sunspots", type = "l")
lattice::xyplot(sunspots ~ year, data = Sunspot, type = "l", 
                main = "Yearly sunspots", aspect = "xy")
ggplot2::ggplot(data = Sunspot, aes(x = year, y = sunspots)) + 
           geom_line() + 
           theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
