% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_oews.R
\name{get_oews}
\alias{get_oews}
\title{Download Occupational Employment and Wage Statistics (OEWS) Data}
\usage{
get_oews(
  simplify_table = TRUE,
  suppress_warnings = TRUE,
  return_diagnostics = FALSE,
  fast_read = TRUE,
  cache = check_bls_cache_env()
)
}
\arguments{
\item{simplify_table}{Logical.  If TRUE (default), remove columns from the result that are internal BLS references or can be derived from other elements in the table.}

\item{suppress_warnings}{Logical. If TRUE (default), suppress individual download warnings and diagnostic messages
for cleaner output during batch processing. If FALSE, returns the data and prints warnings and messages to the console.}

\item{return_diagnostics}{Logical. If TRUE, returns a bls_data_collection object
with full diagnostics. If FALSE (default), returns just the data table.}

\item{fast_read}{Logical.  If TRUE (default), derives lookup values directly from series_id to avoid reading the series file, to speed download process. With fast_read, the data can download in 17 seconds (depending on bandwidth).  Without fast_read, the same download takes 57 seconds.}

\item{cache}{Logical.  Uses USE_BLS_CACHE environment variable, or defaults to FALSE. If TRUE, will download a cached file from BLS server and update cache if BLS server indicates an updated file.}
}
\value{
By default, returns a data.table with OEWS data. If return_diagnostics = TRUE,
  returns a bls_data_collection object containing data and comprehensive diagnostics. The columns in the returned data frame when `simplify_table = TRUE` are listed below.  Unless otherwise specified, all data is returned as a character string to preserve the value of leading and trailing zeroes.
 \itemize{
    \item series_id - The unique OEWS series identifier.
    \item year - The year to which the estimate refers.  Because OEWS is not time series data, this is always the most recent year.
    \item value - Numeric. The value of the given data type, for the given area, in the given industry and occupation.
    \item seasonal - Whether or not the data is seasonally adjusted.
    \item areatype_code - Code representing the type of area (National ("N"), Statewide ("S"), or Local ("M")).
    \item industry_code - NAICS code of the industry.
    \item occupation_code - SOC code of the occupation. Description given by occupation_name.
    \item datatype_code - Lookup code for the data type of a given row.  Description given by datatype_name.
    \item state_code - Two-digit FIPS code for the state.
    \item area_code - The unique OEWS code for a substate area. Description given by area_name.
    \item series_title - Descriptive title of the full series ID.
    \item occupation_name - The text description of the occupation.
    \item occupation_description - More detailed description of the tasks associated with the occupation.
    \item area_name - The text description of the area.
    \item datatype_name - The text description of the type of data represented by `value`.
    
  }
}
\description{
This function downloads and joins together occupational employment and wage data
from the Bureau of Labor Statistics OEWS program. The data includes employment
and wage estimates by occupation and geographic area. Note that OEWS is a large data set (over 6 million rows), so it will require longer to download.
}
\examples{
\donttest{
# Download current OEWS data
oews_data <- get_oews()

# View available occupations
unique(oews_data$occupation_name)

# Filter for specific occupation
software_devs <- oews_data[grepl("Software", occupation_name)]

# Get full diagnostic object if needed
oews_with_diagnostics <- get_oews(return_diagnostics = TRUE)
print_bls_warnings(oews_with_diagnostics)
}

}
