% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLRPM.R
\name{BLRPM.sim}
\alias{BLRPM.sim}
\title{Simulating precipitation with the BLRPM}
\usage{
BLRPM.sim(lambda,gamma,beta,eta,mux,t.sim,t.acc,interval,offset)
}
\arguments{
\item{lambda}{\code{value} specifying the expected storm generation rate [1/units.time]}

\item{gamma}{\code{value} specifying the expected storm duration[1/units.time]}

\item{beta}{\code{value} specifying the expected cell generation rate [1/units.time]}

\item{eta}{\code{value} specifying the expected cell duration [1/units.time]}

\item{mux}{\code{value} specifying the expected cell intenstity [mm/unit.time]}

\item{t.sim}{\code{value} specifying the simulation length [units.time]}

\item{t.acc}{\code{value} specifying the length of the accumulated time series [units.time]. 
Note: if longer than t.sim only zeros are added after t.sim.}

\item{interval}{\code{value} specifying the accumulation time step [units.time]}

\item{offset}{\code{value} specifying the offset of the accumulated time series with 
respect to the start time of the simulation [units.time]. Note: negative values are not allowed.}
}
\value{
$storms returns \code{data.frame} containing information about storms: start, end, number of cells

$cells returns \code{data.frame} containing information about cells: start, end, intensity, storm index

$sfn returns \code{stepfunction} used to accumulate precipitation time series

$RR returns \code{vector} of accumulated precipitation with time step \code{interval} [mm/interval]

$time returns \code{vector} of time steps [interval]
}
\description{
\code{BLRPM.sim} is the main function for simulating precipitation with the Bartlett-Lewis rectangular pulse model.
It generates storms and cells using the given five BLRPM parameters \code{lambda, gamma, beta, eta, mux} for a given
simulation time \code{t.sim}. The function \code{BLRPM.sim} then accumulates a precipitation time series of length 
\code{t.akk} (typically the same as t.sim) with an accumulation time step \code{interval} from the generated
storms and cells. An \code{offset} can be used to delay the precipitation time series for initialization reasons.
\code{BLRPM.sim} returns a list of different variables and data.frames: \code{Storms, Cells, Stepfun, Precip, time}.
}
\examples{
lambda <- 4/240
gamma <- 1/10
beta <- 0.3
eta <- 2
mux <- 4
t.sim <- 240
t.acc <- t.sim
interval <- 1
offset <- 0
simulation <- BLRPM.sim(lambda,gamma,beta,eta,mux,t.sim,t.acc=t.sim,interval,offset)
}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}

