% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetData.R
\name{MatchInputsToProblem}
\alias{MatchInputsToProblem}
\title{Match Inputs to Problem}
\usage{
MatchInputsToProblem(
  DFInputs = data.frame(),
  NObs = nrow(DFInputs),
  InLabObs = DFInputs[, ThisProblem$InLabName, drop = FALSE],
  InVarObs = DFInputs[, ThisProblem$InVar$Name, drop = FALSE],
  InCompObs = DFInputs[, ThisProblem$InCompName, drop = FALSE],
  ThisProblem = NULL,
  NInVar = ThisProblem$N["InVar"],
  InVarName = ThisProblem$InVar$Name,
  InVarMCR = ThisProblem$InVar$MCR,
  InVarType = ThisProblem$InVar$Type,
  NInComp = ThisProblem$N["InComp"],
  InCompName = ThisProblem$InCompName,
  NComp = ThisProblem$N["Comp"],
  CompName = ThisProblem$Comp$Name,
  NDefComp = ThisProblem$N["DefComp"],
  DefCompName = ThisProblem$DefComp$Name,
  DefCompFromNum = ThisProblem$DefComp$FromNum,
  DefCompFromVar = ThisProblem$DefComp$FromVar,
  DefCompSiteDens = ThisProblem$DefComp$SiteDens
)
}
\arguments{
\item{DFInputs}{A data.frame object with, at a minimum, columns named for
`ThisProblem$InLabName`, `ThisProblem$InVar$Name` and
`ThisProblem$InCompName`.}

\item{NObs}{integer; the number of chemistry observations}

\item{InLabObs}{character matrix with NObs rows and InLab columns; the input
labels for each observation}

\item{InVarObs}{matrix with `NObs` rows and `NInVar` columns; the input
variables for each observation}

\item{InCompObs}{matrix with `NObs` rows and `NInComp` columns; the input
component concentrations for each observation}

\item{ThisProblem}{a list object following the template of BlankProblem}

\item{NInVar}{integer; Number of input variables}

\item{InVarName}{character vector of length `NInVar`; Names of input
variables}

\item{InVarMCR}{integer vector of length `NInVar`;  Mass compartments of
input variables}

\item{InVarType}{character vector of length `NInVar`; Types of input
variables}

\item{NInComp}{integer; Number in input components}

\item{InCompName}{character vector of length `NInComp`; names of input
components}

\item{NComp}{integer; Number of components}

\item{CompName}{character vector of length `NComp`; component names}

\item{NDefComp}{integer; Number of defined components}

\item{DefCompName}{character vector of length `NDefComp`; defined component
names}

\item{DefCompFromNum}{numeric vector of length `NDefComp`; the number the
defined component is formed from}

\item{DefCompFromVar}{character vector of length `NDefComp`; the column used
to form the defined component}

\item{DefCompSiteDens}{numeric vector of length `NDefComp`; the binding site
density of each defined component}
}
\value{
Returns a \code{list} object with the following components:
\describe{
  \item{NObs}{integer; the number of chemistry observations}
  \item{InLabObs}{matrix with NObs rows and InLab columns; the input labels
    for each observation}
  \item{InVarObs}{matrix with NObs rows and InVar columns; the input
    variables for each observation}
  \item{InCompObs}{matrix with NObs rows and InComp columns; the input
    component concentrations for each observation}
  \item{\code{SysTempCelsiusObs}}{numeric vector of length \code{NObs}; input
   temperatures, in Celsius}
  \item{\code{SysTempKelvinObs}}{numeric vector of length \code{NObs}; input
   temperatures, in Kelvin}
 \item{\code{pHObs}}{numeric vector (\code{NObs}); input pH for each
   observation}
 \item{\code{TotConcObs}}{numeric matrix with \code{NObs} rows and
   \code{NComp} columns; the total concentrations of each component,
   including derived components}
 \item{\code{HumicSubstGramsPerLiterObs}}{numeric matrix with \code{NObs}
   rows and 2 columns; the total concentration of humic substances (humic/HA
   and fulvic/FA) in grams per liter}
}
}
\description{
`MatchInputsToProblem` will take the input variables and
  component concentrations and match/transform them to the inputs for full
  list of components, including defined components and WHAM components.
}
\seealso{
Other BLMEngine Functions: 
\code{\link{CommonParameterDefinitions}},
\code{\link{GetData}()},
\code{\link{ReadInputsFromFile}()}
}
\concept{BLMEngine Functions}
