% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPSclass.R
\docType{class}
\name{PPS-class}
\alias{PPS-class}
\alias{.PPS}
\title{This class is a generic container for PPS data sets.}
\description{
This class is a generic container for PPS data sets.
}
\section{Slots}{

\describe{
\item{\code{infections}}{Character vector storing names of infections in PPS}

\item{\code{num_hai_patients}}{Named numeric containing patients having healthcare-associated infections.}

\item{\code{num_survey_patients}}{Number of patients in point prevalence survey.}

\item{\code{length_of_stay}}{Length of stay of all patients in hospitals. This is need for the prevalence to incidence conversion with the Rhame-Sudderth formula.}

\item{\code{loi_pps}}{A list containing length of infections from all patients in the PPS. In PPS this is usually calculated as the time from infection onset until the date of the survey.}

\item{\code{hospital_discharges}}{The number of hospital discharges.}

\item{\code{num_hai_patients_by_stratum}}{A list containing for each infection the number of patients in each age and gender stratum.}

\item{\code{num_hai_patients_by_stratum_prior}}{The prior weight (counts) for each infection, age and gender stratum. This is used for smooting the age and gender distribution when small numbers are observed.}

\item{\code{mccabe_scores_distr}}{The observed McCabe scores (counts) for each infection, age and gender stratum from the PPS.}

\item{\code{mccabe_by_stratum_prior}}{The prior weight (counts) for each infection, McCabe score, age and gender stratum. This is used for smooting the age and gender distribution when small numbers are observed.}

\item{\code{mccabe_life_exp}}{Named list containing remaining life expectancies for each McCabe score (NONFATAL, ULTFATAL, RAPFATAL).}

\item{\code{num_survey_patients_by_stratum}}{Number of survey patients stratified by infection, age and gender. If this parameter is provided the methodology described in Cassini et al. (2016) <doi:https://doi.org/10.1371/journal.pmed.1002150> is applied.}

\item{\code{population}}{Population size}

\item{\code{country}}{Name of the country in which PPS was conducted}

\item{\code{bhai_options}}{Options with which bhai was run. If bhai was not run yet, this is an empty list.}

\item{\code{bhai_summary}}{Summary statistics of bhai. If bhai was not run yet, this is an empty list.}
}}

