#' @title  Simulate a sample of group assignments, Z
#' @description  Simulate a sample of group assignments, Z from multplication of density of X and current probabilities
#'
#' @param model.attributes  Model attributes generated by \code{initialize.model.attributes}
#' @param parm  The whole parameters from current iteration
#'
#' @return  A sample of Z
#' @noRd

simulated.Z = function(model.attributes, parm){
  
  dx <- rep(NA, model.attributes$G)
  if(model.attributes$L > 1){
    for(t in 1:model.attributes$times){
      for(i in 1:model.attributes$S){
        # Assign group based on the density 
        for(l in 1:model.attributes$G){
          dx[l] <- dmvnorm(parm$X[i,,t],parm$mu[l,],parm$omega[l,,])
        }
        Zit.aux <- dx * parm$probs
        Zit.aux <- Zit.aux/sum(Zit.aux, na.rm = T)
        parm$Z[i,t] <- sample(x=seq(1,model.attributes$G),size=1,prob=Zit.aux)
      }
    }
  }else{
    for(t in 1:model.attributes$times){
      for(i in 1:model.attributes$S){
        # Assign group based on the density 
        for(l in 1:model.attributes$G){
          dx[l] <- dnorm(parm$X[i,,t],parm$mu[l,],sqrt(parm$omega[l,,]))
        }
        Zit.aux <- dx * parm$probs
        Zit.aux <- Zit.aux/sum(Zit.aux, na.rm = T)

        parm$Z[i,t] <- sample(x=seq(1,model.attributes$G),size=1,prob=Zit.aux)
      }
    }
  }
  # }else{
  #   dx <- rep(NA, model.attributes$G)
  #   for(t in 1:model.attributes$times){
  #     for(i in 1:model.attributes$S){
  #       # Assign group with the largest value of density
  #       for(l in 1:model.attributes$G){
  #        dx[l] <- dnorm(parm$X[i,,t],parm$mu[l,],parm$omega[l,,])
  #       }
  #       Zit.aux <- dx*parm$probs
  #       Zit.aux <- Zit.aux/sum(Zit.aux)
  #       parm$Z[i,t] <- sample(x=seq(1,model.attributes$G),size=1,prob=Zit.aux)
  #     }
  #   }
    
  return(parm)
}
