% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ib.plot.R
\name{ib.plot.bcea}
\alias{ib.plot.bcea}
\alias{ib.plot}
\title{Incremental Benefit (IB) Distribution Plot}
\usage{
\method{ib.plot}{bcea}(
  he,
  comparison = NULL,
  wtp = 25000,
  bw = "bcv",
  n = 512,
  xlim = NULL,
  graph = options("bcea.graph"),
  ...
)

ib.plot(he, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{comparison}{In the case of multiple interventions, specifies the one
to be used in comparison with the reference. Default value of \code{NULL}
forces R to consider the first non-reference intervention as the comparator.
Controls which comparator is used when more than 2 interventions are present}

\item{wtp}{The value of the willingness to pay threshold. Default value at
\code{25000}.}

\item{bw}{Identifies the smoothing bandwidth used to construct the kernel
estimation of the IB density.}

\item{n}{The number of equally spaced points at which the density is to be
estimated.}

\item{xlim}{The limits of the plot on the x-axis.}

\item{graph}{A string used to select the graphical engine to use for
plotting. Should (partial-) match the three options \code{"base"},
\code{"ggplot2"} or \code{"plotly"}. Default value is \code{"base"}. This is set globally
upon loading \code{BCEA} and can be modified for instance by using
\code{options("bcea.graph"="gg")}, or \verb{options("bcea.graph="plotly")}. Partial
matching still applies (so \code{gg} or \code{pl} also work). Not all plotting
functions have a \code{"plotly"} implementation, yet -- see help for the specifics.}

\item{...}{Additional arguments}
}
\value{
\item{ib}{ A ggplot object containing the requested plot. Returned
only if \code{graph="ggplot2"}. } The function produces a plot of the
distribution of the Incremental Benefit for a given value of the willingness
to pay parameter. The dashed area indicates the positive part of the
distribution (i.e. when the reference is more cost-effective than the
comparator).
}
\description{
Plots the distribution of the Incremental Benefit (IB) for a given value of
the willingness to pay threshold.
}
\examples{
data("Vaccine")
he <- BCEA::bcea(eff, cost)
ib.plot(he)

}
\references{
\insertRef{Baio2011}{BCEA}

\insertRef{Baio2013}{BCEA}
}
\seealso{
\code{\link[=bcea]{bcea()}},
\code{\link[=ceplane.plot]{ceplane.plot()}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\keyword{hplot}
