% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_study_lineup.R
\name{do_study_lineup}
\alias{do_study_lineup}
\title{Compute lineups with their statistics}
\usage{
do_study_lineup(data, day_num, game_code_num, team_sel, season = "2025-2026", verbose)
}
\arguments{
\item{data}{Play-by-play prepared data from a given game.}

\item{day_num}{Day number.}

\item{game_code_num}{Game code.}

\item{team_sel}{One of the teams involved in the game.}

\item{season}{Season string.}

\item{verbose}{Logical to indicate if the information of the 
computations must be provided.}
}
\value{
A list with four data frames:
\itemize{
 \strong{data_lin}: Statistics obtained by every lineup.
 \strong{data_pos}: Start of each possession.
 \strong{data_usg}: Possessions ended by each player.  
 \strong{data_usg_act}: Actions that ended each possession per player.   
}
}
\description{
This is an improvement of \code{\link{do_lineup}} to obtain all the 
information related to the lineups that a given team shows during a game.
}
\note{
A possession lasts 24 seconds in the ACB league.
}
\examples{
\dontrun{
library(dplyr)
df0 <- acb_vbc_cz_pbp_2223

day_num <- unique(acb_vbc_cz_pbp_2223$day)
game_code <- unique(acb_vbc_cz_pbp_2223$game_code)

# Starting players:
acb_games_2223_sl <- acb_vbc_cz_sl_2223 \%>\%
  dplyr::filter(period == "1C")

# Prepare data:
df1 <- do_prepare_data(df0, day_num, 
                       acb_games_2223_sl, acb_games_2223_info,
                       game_code)

teams_game <- sort(unique(df1$team))

# Study the lineups:
data_res <- do_study_lineup(df1, day_num, game_code, teams_game[1], "2022-2023", FALSE) 
}

}
\seealso{
\code{\link{do_lineup}}, \code{\link{do_possession}}, 
\code{\link{do_lineup_metrics}}, \code{\link{do_usage}}
}
\author{
Guillermo Vinue
}
