% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vision.R
\name{analyze}
\alias{analyze}
\alias{computervision}
\alias{describe}
\alias{detect_objects}
\alias{area_of_interest}
\alias{tag}
\alias{categorize}
\alias{read_text}
\alias{list_computervision_domains}
\alias{make_thumbnail}
\title{Interface to Azure Computer Vision API}
\usage{
analyze(endpoint, image, domain = NULL, feature_types = NULL,
  language = "en", ...)

describe(endpoint, image, language = "en", ...)

detect_objects(endpoint, image, ...)

area_of_interest(endpoint, image, ...)

tag(endpoint, image, language = "en", ...)

categorize(endpoint, image, ...)

read_text(endpoint, image, detect_orientation = TRUE, language = "en", ...)

list_computervision_domains(endpoint, ...)

make_thumbnail(endpoint, image, outfile, width = 50, height = 50,
  smart_crop = TRUE, ...)
}
\arguments{
\item{endpoint}{A computer vision endpoint.}

\item{image}{An image to be sent to the endpoint. This can be either a filename, a publicly accessible URL, or a raw vector holding the file contents.}

\item{domain}{For \code{analyze}, an optional domain-specific model to use to analyze the image. Can be "celebrities" or "landmarks".}

\item{feature_types}{For \code{analyze}, an optional character vector of more detailed features to return. This can be one or more of: "categories", "tags", "description", "faces", "imagetype", "color", "adult", "brands" and "objects". If not supplied, defaults to "categories".}

\item{language}{A 2-character code indicating the language to use for tags, feature labels and descriptions. The default is \code{en}, for English.}

\item{...}{Arguments passed to lower-level functions, and ultimately to \code{call_cognitive_endpoint}.}

\item{detect_orientation}{For \code{read_text}, whether to automatically determine the image's orientation.}

\item{outfile}{For \code{make_thumbnail}, the filename for the generated thumbnail. Alternatively, if this is NULL the thumbnail is returned as a raw vector.}

\item{width, height}{For \code{make_thumbnail}, the dimensions for the returned thumbnail.}

\item{smart_crop}{For \code{make_thumbnail}, whether to automatically determine the best location to crop for the thumbnail. Useful when the aspect ratios of the original image and the thumbnail don't match.}
}
\value{
\code{analyze} returns a list containing the results of the analysis. The components will vary depending on the domain and feature types requested.

\code{describe} returns a list with two components: \code{tags}, a vector of text labels; and \code{captions}, a data frame of descriptive sentences.

\code{detect_objects}  returns a dataframe giving the locations and types of the detected objects.

\code{area_of_interest} returns a length-4 numeric vector, containing the top-left coordinates of the area of interest and its width and height.

\code{tag} and \code{categorize} return a data frame of tag and category information, respectively.

\code{read_text} returns the extracted text as a list with one component per region that contains text. Each component is a vector of character strings.

\code{list_computervision_domains} returns a character vector of domain names.

\code{make_thumbnail} returns a raw vector holding the contents of the thumbnail, if the \code{outfile} argument is NULL. Otherwise, the thumbnail is saved into \code{outfile}.
}
\description{
Interface to Azure Computer Vision API
}
\details{
\code{analyze} extracts visual features from the image. To obtain more detailed features, specify the \code{domain} and/or \code{feature_types} arguments as appropriate.

\code{describe} attempts to provide a text description of the image.

\code{detect_objects} detects objects in the image.

\code{area_of_interest} attempts to find the "interesting" part of an image, meaning the most likely location of the image's subject.

\code{tag} returns a set of words that are relevant to the content of the image. Not to be confused with the \code{\link{add_tags}} or \code{\link{add_image_tags}} functions that are part of the Custom Vision API.

\code{categorize} attempts to place the image into a list of predefined categories.

\code{read_text} performs optical character recognition (OCR) on the image.

\code{list_domains} returns the predefined domain-specific models that can be queried by \code{analyze} for deeper analysis. Not to be confused with the domains available for training models with the Custom Vision API.

\code{make_thumbnail} generates a thumbnail of the image, with the specified dimensions.
}
\examples{
\dontrun{

vis <- computervision_endpoint(
    url="https://accountname.cognitiveservices.azure.com/",
    key="account_key"
)

list_domains(vis)

# analyze a local file
analyze(vis, "image.jpg")
# picture on the Internet
analyze(vis, "https://example.com/image.jpg")
# as a raw vector
analyze(vis, readBin("image.jpg", "raw", file.size("image.jpg")))

# analyze has optional extras
analyze(vis, "image.jpg", feature_types=c("faces", "objects"))

describe(vis, "image.jpg")
detect_objects(vis, "image.jpg")
area_of_interest(vis, "image.jpg")
tag(vis, "image.jpg")  # more reliable than analyze(*, feature_types="tags")
categorize(vis, "image.jpg")
read_text(vis, "scanned_text.jpg")

}
}
\seealso{
\code{\link{computervision_endpoint}}, \code{\link[AzureCognitive:call_cognitive_endpoint]{AzureCognitive::call_cognitive_endpoint}}

\href{https://docs.microsoft.com/en-us/azure/cognitive-services/Computer-vision/Home}{Computer Vision documentation}
}
