% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_endpoint.R
\name{table_endpoint}
\alias{table_endpoint}
\alias{call_table_endpoint}
\title{Table storage endpoint}
\usage{
table_endpoint(
  endpoint,
  key = NULL,
  token = NULL,
  sas = NULL,
  api_version = getOption("azure_storage_api_version")
)

call_table_endpoint(
  endpoint,
  path,
  options = list(),
  headers = list(),
  body = NULL,
  ...,
  http_verb = c("GET", "DELETE", "PUT", "POST", "HEAD", "PATCH"),
  http_status_handler = c("stop", "warn", "message", "pass"),
  return_headers = (http_verb == "HEAD"),
  metadata = c("none", "minimal", "full"),
  num_retries = 10
)
}
\arguments{
\item{endpoint}{For \code{table_endpoint}, the URL of the table service endpoint. This will be of the form \verb{https://\{account-name\}.table.core.windows.net} if the service is provided by a storage account in the Azure public cloud, while for a CosmosDB database, it will be of the form \verb{https://\{account-name\}.table.cosmos.azure.com:443}. For \code{call_table_endpoint}, an object of class \code{table_endpoint}.}

\item{key}{The access key for the storage account.}

\item{token}{An Azure Active Directory (AAD) authentication token. For compatibility with AzureStor; not used for table storage.}

\item{sas}{A shared access signature (SAS) for the account. At least one of \code{key} or \code{sas} should be provided.}

\item{api_version}{The storage API version to use when interacting with the host. Defaults to "2019-07-07".}

\item{path}{For \code{call_table_endpoint}, the path component of the endpoint call.}

\item{options}{For \code{call_table_endpoint}, a named list giving the query parameters for the operation.}

\item{headers}{For \code{call_table_endpoint}, a named list giving any additional HTTP headers to send to the host. AzureCosmosR will handle authentication details, so you don't have to specify these here.}

\item{body}{For \code{call_table_endpoint}, the request body for a PUT/POST/PATCH call.}

\item{...}{For \code{call_table_endpoint}, further arguments passed to \code{AzureStor::call_storage_endpoint} and \code{httr::VERB}.}

\item{http_verb}{For \code{call_table_endpoint}, the HTTP verb (method) of the operation.}

\item{http_status_handler}{For \code{call_table_endpoint}, the R handler for the HTTP status code of the response. \code{"stop"}, \code{"warn"} or \code{"message"} will call the corresponding handlers in httr, while \code{"pass"} ignores the status code. The latter is primarily useful for debugging purposes.}

\item{return_headers}{For \code{call_table_endpoint}, whether to return the (parsed) response headers instead of the body. Ignored if \code{http_status_handler="pass"}.}

\item{metadata}{For \code{call_table_endpoint}, the level of ODATA metadata to include in the response.}

\item{num_retries}{The number of times to retry the call, if the response is a HTTP error 429 (too many requests). The Cosmos DB endpoint tends to be aggressive at rate-limiting requests, to maintain the desired level of latency. This will generally not affect calls to an endpoint provided by a storage account.}
}
\value{
\code{table_endpoint} returns an object of class \code{table_endpoint}, inheriting from \code{storage_endpoint}. This is the analogue of the \code{blob_endpoint}, \code{file_endpoint} and \code{adls_endpoint} classes provided by the AzureStor package.

\code{call_table_endpoint} returns the body of the response by default, or the headers if \code{return_headers=TRUE}. If \code{http_status_handler="pass"}, it returns the entire response object without modification.
}
\description{
Table storage endpoint object, and method to call it.
}
\examples{
\dontrun{

# storage account table endpoint
table_endpoint("https://mystorageacct.table.core.windows.net", key="mykey")

# Cosmos DB table endpoint
table_endpoint("https://mycosmosdb.table.cosmos.azure.com:443", key="mykey")

}
}
\seealso{
\link{storage_table}, \link{table_entity}, \link[AzureStor:storage_call]{AzureStor::call_storage_endpoint}

\href{https://docs.microsoft.com/en-us/rest/api/storageservices/table-service-rest-api}{Table service REST API reference}

\href{https://docs.microsoft.com/en-us/rest/api/storageservices/authorize-requests-to-azure-storage}{Authorizing requests to Azure storage services}
}
