% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mongo_endpoint.R
\name{cosmos_mongo_endpoint}
\alias{cosmos_mongo_endpoint}
\alias{cosmos_mongo_connection}
\alias{cosmos_mongo_connection.cosmos_mongo_endpoint}
\title{MongoDB endpoint for Azure Cosmos DB}
\usage{
cosmos_mongo_endpoint(
  host,
  key,
  mongo_options = list(),
  connection_string = NULL
)

cosmos_mongo_connection(endpoint, ...)

\method{cosmos_mongo_connection}{cosmos_mongo_endpoint}(endpoint, collection, database, ...)
}
\arguments{
\item{host}{For \code{cosmos_mongo_endpoint}, the URL of the Cosmos DB MongoDB endpoint. Usually of the form "https://{account-name}.mongo.cosmos.azure.com:443/".}

\item{key}{For \code{cosmos_mongo_endpoint}, a string containing the access key (password) for the endpoint. Can be either a read-write or read-only key.}

\item{mongo_options}{For \code{cosmos_mongo_endpoint}, a named list containing any additional parameters for the MongoDB connection string.}

\item{connection_string}{Alternatively, the full connection string for the MongoDB endpoint. If this is supplied, all other arguments to \code{cosmos_mongo_endpoint} are ignored. Note that if you already have the full connection string, you most likely do not need AzureCosmosR and can call \code{mongolite::mongo} directly.}

\item{endpoint}{For \code{cosmos_mongo_connection}, a MongoDB endpoint object as obtained from \code{cosmos_mongo_endpoint}.}

\item{...}{Optional arguments passed to lower-level functions.}

\item{collection, database}{For \code{cosmos_mongo_connection}, the collection and database to connect to.}
}
\value{
For \code{cosmos_mongo_endpoint}, an object of S3 class \code{cosmos_mongo_endpoint}.

For \code{cosmos_mongo_connection}, an object of class \code{mongolite::mongo} which can then be used to interact with the given collection.
}
\description{
MongoDB endpoint for Azure Cosmos DB
}
\details{
These functions act as a bridge between the Azure resource and the functionality provided by the mongolite package.
}
\examples{
\dontrun{

mendp <- cosmos_mongo_endpoint("https://mymongoacct.mongo.cosmos.azure.com:443",
    key="mykey")

cosmos_mongo_connection(mendp, "mycollection", "mydatabase")

}
}
\seealso{
\link{az_cosmosdb}, \link[mongolite:mongo]{mongolite::mongo}

For the SQL API client framework: \link{cosmos_endpoint}, \link{cosmos_database}, \link{cosmos_container}, \link{query_documents}
}
