








use crate::{
    use_file,
    util_libc::{last_os_error, Weak},
    Error,
};
use core::mem::{self, MaybeUninit};

type GetEntropyFn = unsafe extern "C" fn(*mut u8, libc::size_t) -> libc::c_int;

pub fn getrandom_inner(dest: &mut [MaybeUninit<u8>]) -> Result<(), Error> {

    static GETENTROPY: Weak = unsafe { Weak::new("getentropy\0") };
    if let Some(fptr) = GETENTROPY.ptr() {
        let func: GetEntropyFn = unsafe { mem::transmute(fptr) };
        for chunk in dest.chunks_mut(256) {
            let ret = unsafe { func(chunk.as_mut_ptr() as *mut u8, chunk.len()) };
            if ret != 0 {
                return Err(last_os_error());
            }
        }
        Ok(())
    } else {


        use_file::getrandom_inner(dest)
    }
}
