% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{zb_view}
\alias{zb_view}
\title{View zones}
\usage{
zb_view(z, alpha = 0.4, palette = c("rings", "hcl", "dartboard"), title = NULL)
}
\arguments{
\item{z}{An `sf` object containing zones covering the region}

\item{alpha}{Alpha transparency, number between 0 (fully transparent) and 1 (not transparent)}

\item{palette}{Palette type, one of \code{"hcl"} (a palette based on the HCL color space), \code{"rings"} (a palette which colors the rings using the YlOrBr color brewer palette), \code{"dartboard"} (a palette which resembles a dartboard)}

\item{title}{The title of the plot}
}
\value{
An interactive map created with `tmap`
}
\description{
This function opens an interactive map of the zones
}
\examples{
\donttest{
z = zb_zone(london_c(), london_a())
zb_view(z, palette = "rings")
}
}
