% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{create_option}
\alias{create_option}
\title{Create package option}
\usage{
create_option(name, default, description = name, .envir = parent.frame())
}
\arguments{
\item{name}{\verb{[character(1)]} Name of the option}

\item{default}{\verb{[any]} Default value of the option}

\item{description}{\verb{[character(1)]} Description of the option}

\item{.envir}{Environment in which the option is defined.
Default is suitable for use inside your package.}
}
\value{
Invisible \code{zephyr_option} object
}
\description{
Use inside your package to setup a \code{zephyr_option} that you can use in your
functions with \code{\link[=get_option]{get_option()}}. The specification is stored inside the
environment of your package.

For more information and how to get started see \code{\link[=use_zephyr]{use_zephyr()}}.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
create_option(
  name = "answer",
  default = 42,
  description = "This is supposed to be the question"
)
\dontshow{\}) # examplesIf}
}
