% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinb_analysis_tool.R
\name{zinb_analysis_tool}
\alias{zinb_analysis_tool}
\title{Perform ZINB analysis on real data.}
\usage{
zinb_analysis_tool(
  grp_data,
  pair_data,
  merge_list,
  min_freq = 15,
  min_size = 20,
  n_perm = 20,
  n_copies = round(detectCores()/2),
  seed = 1234
)
}
\arguments{
\item{grp_data}{a data.frame containing the following 2 columns:
\itemize{
  \item{AE_NAME: }{The name of the Adverse Event (AE)}
  \item{GROUP_NAME: }{The AE group of the AE}
}}

\item{pair_data}{a data.frame containing the following 3 columns:
\itemize{
  \item{ID: }{The unique identifier of the report}
  \item{VAX_TYPE: }{The vaccines appeared in the report}
  \item{AE_NAME: }{The AEs appeared in the report}

  Please notice that this data reflects all the vaccine-AE combinations. If n1
  AEs and n2 vaccines are mentioned in one reports, then n1*n2 pairs should be
  generated in the data.
}}

\item{merge_list, }{a list with nesting lists, indicating which vaccines are of interest and
which vaccines are to be merged. For example, if you are interested in vaccines FLU3 and FLU4,
and you want to merge them into one vaccine FLU, you would like to add list(c('FLU3','FLU4'),'FLU')
in this list}

\item{min_freq}{a non-negative integer indicating the criteria for scarce AEs.
If an AE appears less than `min_freq` times in the data.frame pair_data, it will
be labeled as scarce and be ignored in the study. It can be set to 0.}

\item{min_size}{a positive integer indicating the criteria for small AE groups.
If an AE group contains less than `min_size` AEs, it will be label as a small AE group,
and be ignored from the study.}

\item{n_perm}{a positive integer that decide the number of permutations to determine
the p value for observed RRs.}

\item{n_copies}{a positive integer indicating the number of permutations can
be done in parallel. This number is default to half of the computer's number
of cores.}

\item{seed}{to obtain reproducible result, you may want to set this seed.}
}
\value{
A big data.frame containing the following columns:
\itemize{
  \item{y: }{The weighted count of the vaccine-AE cell}
  \item{E: }{The baseline frequency of the vaccine-AE cell}
  \item{vaccine: }{The vaccine type}
  \item{AE_grp: }{The AE group}
  \item{AE: }{The Adverse Event (AE)}
  \item{s: }{The group level RR for this vaccine}
  \item{r: }{The over dispersion parameter for this AE group}
  \item{p: }{The zero component probability of this vaccine-AE_grp combination}
  \item{beta: }{The log mean parameter for this vaccine-AE_grp combination}
  \item{lambda_hat: }{The individual AE RR (Bayes Estimator)}
  \item{s_pval: }{The p value for s}
  \item{lambda_pval: }{The p value for lambda_hat (individual AE RR)}
}
}
\description{
Perform ZINB analysis on real data.
}
\examples{
data(vaers_data)
data("dd.meddra")
data("merge_list")
big_data = zinb_analysis_tool(dd.meddra[1:10000,],
                              vaers_data[1:10000,],
                              merge_list,
                              n_perm = 2,
                              n_copies = 2)

}
