% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dranchuk-Purvis-Robinson.R
\name{z.DranchukPurvisRobinson}
\alias{z.DranchukPurvisRobinson}
\title{Dranchuk-Purvis-Robinson correlation}
\usage{
z.DranchukPurvisRobinson(pres.pr, temp.pr, tolerance = 1e-13,
  verbose = FALSE)
}
\arguments{
\item{pres.pr}{pseudo-reduced pressure}

\item{temp.pr}{pseudo-reduced temperature}

\item{tolerance}{controls the iteration accuracy}

\item{verbose}{print internal}
}
\description{
Dranchuk-Purvis-Robinson correlation
}
\examples{
## calculate for one Tpr curve at a Ppr
z.DranchukPurvisRobinson(pres.pr = 1.5, temp.pr = 2.0)

## For vectors of Ppr and Tpr:
ppr <- c(0.5, 1.5, 2.5, 3.5, 4.5, 5.5, 6.5)
tpr <- c(1.3, 1.5, 1.7, 2)
z.DranchukPurvisRobinson(pres.pr = ppr, temp.pr = tpr)

## create a matrix of z values
tpr2 <- c(1.05, 1.1, 1.2, 1.3)
ppr2 <- c(0.5, 1.0, 1.5, 2, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5)
sk_corr_2 <- createTidyFromMatrix(ppr2, tpr2, correlation = "DPR")
tibble::as.tibble(sk_corr_2)
}
