% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json-opts.R
\docType{data}
\name{yyjson_read_flag}
\alias{yyjson_read_flag}
\title{Advanced: Values for setting internal options directly on YYJSON library}
\format{
An object of class \code{list} of length 9.
}
\usage{
yyjson_read_flag
}
\description{
This is a list of integer values used for setting flags on the \code{yyjson}
code directly.  This is an ADVANCED option and should be used with caution.
}
\details{
Some of these settings overlap and conflict with code needed to handle
the translation of JSON values to R.

\code{opts_read_json(yyjson_read_flag = c(yyjson_read_flag$x, yyjson_read_flag$y, ...))}

\describe{
\item{YYJSON_READ_NOFLAG}{
Default option (RFC 8259 compliant):
\itemize{
\item{Read positive integer as uint64_t.}
\item{Read negative integer as int64_t.}
\item{Read floating-point number as double with round-to-nearest mode.}
\item{Read integer which cannot fit in uint64_t or int64_t as double.}
\item{Report error if double number is infinity.}
\item{Report error if string contains invalid UTF-8 character or BOM.}
\item{Report error on trailing commas, comments, inf and nan literals.}
}
}

\item{YYJSON_READ_INSITU}{
Read the input data in-situ.
This option allows the reader to modify and use input data to store string
values, which can increase reading speed slightly.
The caller should hold the input data before free the document.
The input data must be padded by at least \code{YYJSON_PADDING_SIZE} bytes.
For example: \code{"[1,2]"} should be \code{"[1,2]\0\0\0\0"}, input length should be 5.
}

\item{YYJSON_READ_STOP_WHEN_DONE}{
Stop when done instead of issuing an error if there's additional content
after a JSON document. This option may be used to parse small pieces of JSON
in larger data, such as "NDJSON"
}

\item{YYJSON_READ_ALLOW_TRAILING_COMMAS}{
Allow single trailing comma at the end of an object or array,
such as \code{"[1,2,3,]"}
}

\item{YYJSON_READ_ALLOW_COMMENTS}{
Allow C-style single line and multiple line comments (non-standard).
}

\item{YYJSON_READ_ALLOW_INF_AND_NAN}{
Allow inf/nan number and literal, case-insensitive,
such as 1e999, NaN, inf, -Infinity (non-standard).
}

\item{YYJSON_READ_NUMBER_AS_RAW}{
Read all numbers as raw strings (value with "YYJSON_TYPE_RAW" type),
inf/nan literal is also read as raw with "ALLOW_INF_AND_NAN" flag.
}

\item{YYJSON_READ_ALLOW_INVALID_UNICODE}{
Allow reading invalid unicode when parsing string values (non-standard).
Invalid characters will be allowed to appear in the string values, but
invalid escape sequences will still be reported as errors.
This flag does not affect the performance of correctly encoded strings.
WARNING: Strings in JSON values may contain incorrect encoding when this
option is used, you need to handle these strings carefully to avoid security
risks.
}

\item{YYJSON_READ_BIGNUM_AS_RAW}{
Read big numbers as raw strings. These big numbers include integers that
cannot be represented by "int64_t" and "uint64_t", and floating-point
numbers that cannot be represented by finite "double".
The flag will be overridden by "YYJSON_READ_NUMBER_AS_RAW" flag.
}
}
}
\examples{
read_json_str(
   '[12.3]', 
   opts = opts_read_json(yyjson_read_flag = yyjson_read_flag$YYJSON_READ_ALLOW_TRAILING_COMMAS)
 )
}
\keyword{datasets}
