% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_pagedown.R
\name{pagedown_business_card_template}
\alias{pagedown_business_card_template}
\alias{pagedown_person}
\title{Generate a full YAML template for your pagedown business card}
\usage{
pagedown_business_card_template(
  name = yml_blank(),
  person = yml_blank(),
  title = yml_blank(),
  phone = yml_blank(),
  email = yml_blank(),
  url = yml_blank(),
  address = yml_blank(),
  logo = yml_blank(),
  .repeat = yml_blank(),
  paperwidth = yml_blank(),
  paperheight = yml_blank(),
  cardwidth = yml_blank(),
  cardheight = yml_blank(),
  cols = yml_blank(),
  rows = yml_blank(),
  mainfont = yml_blank(),
  googlefonts = yml_blank(),
  ...
)

pagedown_person(...)
}
\arguments{
\item{name}{The name}

\item{person}{When you are creating business cards for numerous people with
shared information, passing values to the \code{person} field can override the
default values, which can be any of the values accepted by this function.
Use \code{pagedown_person()} to do so or manually provide them using \code{list(field = value)}.}

\item{title}{The title of the person}

\item{phone}{A phone number}

\item{email}{An email address}

\item{url}{A website URL}

\item{address}{The address}

\item{logo}{A path to a logo file}

\item{.repeat}{The number of cards to repeat. Note that the actual YAML field
is \code{repeat}.}

\item{paperwidth}{The paper width}

\item{paperheight}{The paper height}

\item{cardwidth}{The width of the card}

\item{cardheight}{The height of the card}

\item{cols}{The number of columns in the card grid}

\item{rows}{The rows of columns in the card grid}

\item{mainfont}{The font}

\item{googlefonts}{A character vector of Google Fonts}

\item{...}{additional named R objects, such as characters or lists, to
transform into YAML}
}
\value{
a \code{yml} object
}
\description{
pagedown has a unique output type to make business cards:
\code{pagedown::business_card()}. \code{pagedown_business_card_template()} creates a
YAML template to use for this output. What's unique about this output type is
that almost all of the contents are supplied through YAML. An R Markdown file
that only contains YAML related to the business card is enough to produce the
output, although you can also customize the output in the body of the
document (see the \href{https://pagedown.rbind.io/}{pagedown vignette}). A good
workflow to write a business card is to use
\code{pagedown_business_card_template()} to specify the YAML and pass it to
\code{\link[=use_rmarkdown]{use_rmarkdown()}}, which you can then to knit into business cards.
}
\examples{
pagedown_business_card_template(
  name = "Jane Doe",
  title = "Miss Nobody",
  phone = "+1 123-456-7890",
  email = "jane.doe@example.com",
  url = "www.example.com",
  address = "2020 South Street,
  Sunshine, CA 90000",
  logo = "logo.png",
  .repeat = 12
)

pagedown_business_card_template(
  phone = "+1 123-456-7890",
  url = "www.example.com",
  address = "2020 South Street,
  Sunshine, CA 90000",
  logo = "logo.png",
  person = list(
    pagedown_person(
      name = "Jane Doe",
      title = "Miss Nobody",
      email = "jane.doe@example.com",
      .repeat = 6
    ),
    pagedown_person(
      name = "John Doe",
      title = "Mister Nobody",
      phone = "+1 777-777-7777", # overrides the default phone
      email = "john.doe@example.com",
      .repeat = 6
    )
  ),
  paperwidth = "8.5in",
  paperheight = "11in",
  cols = 4,
  rows = 3
)

}
\seealso{
\code{\link[=use_rmarkdown]{use_rmarkdown()}}

Other pagedown: 
\code{\link{yml_pagedown_opts}()}
}
\concept{pagedown}
