% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num-rmse.R
\name{rmse}
\alias{rmse}
\alias{rmse.data.frame}
\alias{rmse_vec}
\title{Root mean squared error}
\usage{
rmse(data, ...)

\method{rmse}{data.frame}(data, truth, estimate, na_rm = TRUE, ...)

rmse_vec(truth, estimate, na_rm = TRUE, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the \code{truth} and \code{estimate}
columns.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true results
(that is \code{numeric}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names). For \code{_vec()} functions, a \code{numeric} vector.}

\item{estimate}{The column identifier for the predicted
results (that is also \code{numeric}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \code{_vec()} functions, a \code{numeric} vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{rmse_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Calculate the root mean squared error. \code{rmse()} is a metric that is in
the same units as the original data.
}
\examples{
# Supply truth and predictions as bare column names
rmse(solubility_test, solubility, prediction)

library(dplyr)

set.seed(1234)
size <- 100
times <- 10

# create 10 resamples
solubility_resampled <- bind_rows(
  replicate(
    n = times,
    expr = sample_n(solubility_test, size, replace = TRUE),
    simplify = FALSE
  ),
  .id = "resample"
)

# Compute the metric by group
metric_results <- solubility_resampled \%>\%
  group_by(resample) \%>\%
  rmse(solubility, prediction)

metric_results

# Resampled mean estimate
metric_results \%>\%
  summarise(avg_estimate = mean(.estimate))
}
\seealso{
Other numeric metrics: \code{\link{ccc}},
  \code{\link{huber_loss_pseudo}},
  \code{\link{huber_loss}}, \code{\link{iic}},
  \code{\link{mae}}, \code{\link{mape}},
  \code{\link{mase}}, \code{\link{rpd}},
  \code{\link{rpiq}}, \code{\link{rsq_trad}},
  \code{\link{rsq}}, \code{\link{smape}}

Other accuracy metrics: \code{\link{ccc}},
  \code{\link{huber_loss_pseudo}},
  \code{\link{huber_loss}}, \code{\link{iic}},
  \code{\link{mae}}, \code{\link{mape}},
  \code{\link{mase}}, \code{\link{smape}}
}
\author{
Max Kuhn
}
\concept{accuracy metrics}
\concept{numeric metrics}
