% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnn.pfi.R
\name{pnn.pfi}
\alias{pnn.pfi}
\title{Derive the PFI rank of all predictors used in the PNN}
\usage{
pnn.pfi(net, ntry = 1000, seed = 1)
}
\arguments{
\item{net}{A PNN object generated by pnn.fit()}

\item{ntry}{The number of random permutations to try, 1e3 times by default}

\item{seed}{The seed value for the random permutation}
}
\value{
A dataframe with PFI values of all predictors in the PNN
}
\description{
The function \code{pnn.pfi} derives the PFI rank of all predictors used in the PNN
It essentially is a wrapper around the function \code{pnn.x_pfi}.
}
\examples{
data(iris, package = "datasets")
Y <- iris[, 5]
X <- scale(iris[, 1:4])
pnet <- pnn.fit(x = X, y = Y)
\donttest{
pnn.pfi(pnet)
}
}
\seealso{
\code{\link{pnn.x_pfi}}
}
