% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelist.R
\name{codelist.data.frame}
\alias{codelist.data.frame}
\title{Create a Codelist for Data Frame}
\usage{
\method{codelist}{data.frame}(x, names, values, ...)
}
\arguments{
\item{x}{data.frame}

\item{names}{unquoted column name supplying list names}

\item{values}{unquoted colum name supplying list values}

\item{...}{ignored arguments}
}
\value{
see methods
}
\description{
Creates a codelist for data.frame.
Assuming one-to-one correspondence of \code{names}
and \code{values} (error otherwise),
returns a named list of unique values, in
order given by \code{as.factor(names)}.
}
\examples{
library(magrittr)

# Suppose we have a numeric and a character version of treatment:

x <- data.frame(
  TRTN =  c(        0,      1,            2,         0),
  TRTC =  c('placebo', 'drug', 'comparitor', 'placebo')
)

x

# Further, we wish to specify a particular display order:

x$TRTC <- factor(x$TRTC, levels = c('drug', 'comparitor', 'placebo'))

# We can use TRTC as the guide for TRTN:

x \%<>\% modify(TRTN, guide = codelist(x, TRTC, TRTN))

x \%>\% decorations(TRTN)


}
\seealso{
Other codelist: 
\code{\link{codelist}()}
}
\concept{codelist}
\keyword{internal}
