% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{xyz_regression}
\alias{xyz_regression}
\title{Elasticnet with interactions (glmnet)}
\usage{
xyz_regression(X, Y, lambdas = NULL, n_lambda = 10, alpha = 0.9, L = 10,
  standardize = TRUE, standardize_response = TRUE)
}
\arguments{
\item{X}{A matrix.}

\item{Y}{A vector.}

\item{lambdas}{A vector of decreasing real numbers containing user specified values of lambda.}

\item{n_lambda}{A natural number indicating how long the path of lambdas should be.}

\item{alpha}{A real number between 0 and 1 (the elastic net parameter)}

\item{L}{An integer indicating how many projection steps are performed.}

\item{standardize}{A boolean indicating if X should be scaled and centered.}

\item{standardize_response}{A boolean indicating if Y should be scaled and centered.}
}
\value{
\code{N} strongest interactions (of type \code{type}) between \code{X} and \code{Y} after \code{L} projections.
}
\description{
Elasticnet with interactions (glmnet)
}
\examples{
n<-300
p<-1000
#build matrix of predictors
X<-matrix(rnorm(n*p),n,p)
#build a main effect and an interaction into Y
Y<-4*X[,1]*X[,2]-5*X[,4]+rnorm(n)
result<-xyz_regression(X,Y,n_lambda=10,alpha=0.9,L=10)
#print the result
print(result)
#plot the result
plot(result)
}
\references{
G. Thanei, N. Meinshausen and R. Shah (2016). The xyz algorithm for fast interaction search in high-dimensional data. <https://arxiv.org/pdf/1610.05108v1.pdf>
}

