% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_xrnet.R
\name{predict.xrnet}
\alias{predict.xrnet}
\title{Predict function for "xrnet" object}
\usage{
\method{predict}{xrnet}(
  object,
  newdata = NULL,
  newdata_fixed = NULL,
  p = NULL,
  pext = NULL,
  type = c("response", "link", "coefficients"),
  ...
)
}
\arguments{
\item{object}{A \code{\link{xrnet}} object}

\item{newdata}{matrix with new values for penalized variables}

\item{newdata_fixed}{matrix with new values for unpenalized variables}

\item{p}{vector of penalty values to apply to predictor variables}

\item{pext}{vector of penalty values to apply to external data variables}

\item{type}{type of prediction to make using the xrnet model, options include
\itemize{
   \item response
   \item link (linear predictor)
   \item coefficients
}}

\item{...}{pass other arguments to xrnet function (if needed)}
}
\value{
The object returned is based on the value of type as follows:
\itemize{
    \item response: An array with the response predictions based on the data for each penalty combination
    \item link: An array with linear predictions based on the data for each penalty combination
    \item coefficients: A list with the coefficient estimates for each penalty combination. See \code{\link{coef.xrnet}}.
}
}
\description{
Extract coefficients or  predict response in new data using fitted model from an \code{\link{xrnet}} object.
Note that we currently only support returning coefficient estimates that are in the original path(s).
}
\examples{
data(GaussianExample)

fit_xrnet <- xrnet(
    x = x_linear,
    y = y_linear,
    external = ext_linear,
    family = "gaussian"
)

lambda1 <- fit_xrnet$penalty[10]
lambda2 <- fit_xrnet$penalty_ext[10]

coef_xrnet <- predict(
    fit_xrnet,
    p = lambda1,
    pext = lambda2,
    type = "coefficients"
)

pred_xrnet <- predict(
    fit_xrnet,
    p = lambda1,
    pext = lambda2,
    newdata = x_linear,
    type = "response"
)

}
