% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parm.vs.parm.R
\name{parm.vs.parm}
\alias{parm.vs.parm}
\title{Plot parameters vs other parameters}
\usage{
parm.vs.parm(
  object,
  onlyfirst = TRUE,
  abline = FALSE,
  smooth = TRUE,
  type = "p",
  main = "Default",
  ...
)
}
\arguments{
\item{object}{An xpose.data object.}

\item{onlyfirst}{Logical value indicating whether only the first row per
individual is included in the plot.}

\item{abline}{Allows for a line of identity.}

\item{smooth}{Logical value indicating whether an x-y smooth should be
superimposed.  The default is TRUE.}

\item{type}{The plot type - defaults to points only.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{\dots}{Other arguments passed to \code{xpose.plot.default}.}
}
\value{
Returns a stack of xyplots and histograms of parameters against
parameters.
}
\description{
This function plots the parameter values stored in an Xpose data object
versus each other in a series of graphs.  The mirror functionality is
available for this function.
}
\details{
Each of the parameters in the Xpose data object, as specified in
\code{object@Prefs@Xvardef$parms}, is plotted against the rest, creating a
stack of plots.

A wide array of extra options controlling \code{xyplots} are available. See
\code{\link{xpose.plot.default}} and \code{\link{xpose.panel.default}} for
details.
}
\examples{

\dontrun{
## We expect to find the required NONMEM run and table files for run
## 5 in the current working directory
xpdb <- xpose.data(5)


parm.vs.parm(xpdb)


parm.vs.parm(xpdb,mirror=3)
}

}
\seealso{
Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
Andrew Hooker
}
\concept{specific functions}
\keyword{methods}
