% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootgam.plots.R
\name{xp.incl.index.cov.ind}
\alias{xp.incl.index.cov.ind}
\title{Individual inclusion index}
\usage{
xp.incl.index.cov.ind(bootgam.obj = NULL, boot.type = NULL,
  cov.name = NULL, main = NULL, ylb = "ID",
  xlb = "Individual inclusion index", return_plot = TRUE,
  results.tab = NULL, ...)
}
\arguments{
\item{bootgam.obj}{A bootgam or bootscm object.}

\item{boot.type}{Either "bootgam" or "bootscm". Default is NULL, which means the user
will be asked to make a choice.}

\item{cov.name}{The name of the covariate for which to create the plot.}

\item{main}{The title of the plot.}

\item{ylb}{The label for the x-axis.}

\item{xlb}{The label for the y-axis.}

\item{return_plot}{Should a plot object be returned?}

\item{results.tab}{Supply your own results table.}

\item{...}{Additional plotting parameters.}
}
\value{
A lattice plot object is returned.
}
\description{
This function will generate a plot of individual inclusion indexes for a
specific covariate, which can be used to identify influential
individuals for inclusion of that covariate. The index for an individual is calculated as
the observed number of inclusions of that individual when the specific
covariate was included minus the expected number of inclusions (based
on the total bootstrap inclusions), divided by expected.
}
\seealso{
Other bootgam: \code{\link{xp.daic.npar.plot}},
  \code{\link{xp.dofv.npar.plot}},
  \code{\link{xp.inc.cond.stab.cov}},
  \code{\link{xp.inc.ind.cond.stab.cov}},
  \code{\link{xp.inc.stab.cov}},
  \code{\link{xp.incl.index.cov}}

Other bootscm: \code{\link{bootscm.import}},
  \code{\link{xp.daic.npar.plot}},
  \code{\link{xp.dofv.npar.plot}},
  \code{\link{xp.inc.cond.stab.cov}},
  \code{\link{xp.inc.ind.cond.stab.cov}},
  \code{\link{xp.inc.stab.cov}},
  \code{\link{xp.incl.index.cov}}
}
\author{
Ron Keizer
}
