% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose_save.R
\name{xpose_save}
\alias{xpose_save}
\title{Save xpose plot}
\usage{
xpose_save(plot = last_plot(), file = NULL, dir = NULL, device = NULL,
  width = 7, height = 6, units = c("in", "cm", "mm"), dpi = 200, ...)
}
\arguments{
\item{plot}{A xpose plot object.}

\item{file}{A name with file extension (if device is \code{NULL}) to be given to the 
output file. Template variables such as \code{@run} (run number) and \code{@plotfun} 
(plot function) can be used to automatically name files e.g. 
\code{file = '@run_@plotfun.pdf'}.}

\item{dir}{Directory under which the xpose plots will be saved. Template variables 
such as \code{@dir} can be used to generate template names.}

\item{device}{Graphical device to use. Can be either be a device function
(e.g. \code{\link{png}}), or one of 'eps', 'ps', 'tex' (pictex),
'pdf' (default), 'jpeg', 'tiff', 'png', 'bmp', 'svg' or 'wmf' (windows only).}

\item{width, height}{Plot size in \code{units}.}

\item{units}{Units of the plot size ('in', 'cm', or 'mm').}

\item{dpi}{Plot resolution. Applies only to raster output types.}

\item{...}{Additional arguments passed on to \link[ggplot2]{ggsave} or graphics \code{device}.}
}
\description{
Inspired by the \link[ggplot2]{ggsave}, this function 
facilitates the export of xpose plots.
}
\examples{
\dontrun{
xpdb_ex_pk \%>\% 
 dv_vs_ipred() \%>\% 
 xpose_save(file = file.path(tempdir(), "dv_vs_ipred_example.pdf"))
}
}
