% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixes.R
\name{edit_xpose_data}
\alias{edit_xpose_data}
\title{Master xpdb editing function}
\usage{
edit_xpose_data(
  .fun,
  .fname,
  .data,
  ...,
  .problem,
  .source,
  .where,
  check_quos = FALSE
)
}
\arguments{
\item{.fun}{An editing function to be applied to the data.}

\item{.fname}{The name of the editing function.}

\item{.data}{An xpose database object.}

\item{...}{Name-value pairs of expressions. Use \code{NULL} to drop a variable.}

\item{.problem}{The problem from which the data will be modified}

\item{.source}{The source of the data in the xpdb. Can either be 'data' or an output
file extension e.g. 'phi'.}

\item{.where}{A vector of element names to be edited in special (e.g.
\code{.where = c('vpc_dat', 'aggr_obs')} with vpc).}

\item{check_quos}{Check that variables referenced exists. \code{TRUE} matches the
behavior of <\code{\link[xpose:edit_xpose_data]{xpose::edit_xpose_data}}>

These arguments are automatically quoted and evaluated in the
context of the data frame. They support unquoting and splicing.
See the dplyr vignette("programming") for an introduction to these concepts.}
}
\value{
The modified \code{xpose_data} object
}
\description{
Generic function used to build dedicated editing functions
}
\keyword{internal}
