# Extracted from test-CFI.R:133

# setup ------------------------------------------------------------------------
library(testthat)
test_env <- simulate_test_env(package = "xplainfi", path = "..")
attach(test_env, warn.conflicts = FALSE)

# test -------------------------------------------------------------------------
skip_if_not_installed("ranger")
skip_if_not_installed("mlr3learners")
skip_if_not_installed("arf")
set.seed(123)
task = tgen("xor", d = 5)$generate(n = 200)
test_with_resampling(
		CFI,
		task = task,
		learner = lrn("classif.ranger", num.trees = 50, predict_type = "prob"),
		measure = msr("classif.ce"),
		resampling = rsmp("cv", folds = 3),
		n_repeats = 2L
	)
