% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xml_children.R
\name{xml_children}
\alias{xml_children}
\alias{xml_contents}
\alias{xml_length}
\alias{xml_parent}
\alias{xml_parents}
\alias{xml_siblings}
\title{Navigate around the family tree.}
\usage{
xml_children(x)

xml_contents(x)

xml_parents(x)

xml_siblings(x)

xml_parent(x)

xml_length(x, only_elements = TRUE)
}
\arguments{
\item{x}{A document, node, or node set.}

\item{only_elements}{For \code{xml_length}, should it count all children,
or just children that are elements (the default)?}
}
\value{
A node or nodeset (possibly empty). Results are always de-duplicated.
}
\description{
\code{xml_children} returns only elements, \code{xml_contents} returns
all nodes. \code{xml_length} returns the number of children.
\code{xml_parent} returns the parent node, \code{xml_parents}
returns all parents up to the root. \code{xml_siblings} returns all nodes
at the same level.
}
\examples{
x <- read_xml("<foo> <bar><boo /></bar> <baz/> </foo>")
xml_children(x)
xml_children(xml_children(x))
xml_siblings(xml_children(x)[[1]])

# Note the each unique node only appears once in the output
xml_parent(xml_children(x))

# Mixed content
x <- read_xml("<foo> a <b/> c <d>e</d> f</foo>")
# Childen gets the elements, contents gets all node types
xml_children(x)
xml_contents(x)

xml_length(x)
xml_length(x, only_elements = FALSE)
}

