% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{auto_df_to_wb}
\alias{auto_df_to_wb}
\title{Take a data.frame in r and output an openxlsx wb object}
\usage{
auto_df_to_wb(df, auto_number_format = TRUE, titles = NULL,
  footers = NULL, left_header_colnames = NULL, vertical_border = TRUE,
  auto_open = FALSE, return_tab = FALSE, auto_merge = TRUE,
  insert_below_tab = NULL)
}
\arguments{
\item{df}{The data.frame to convert to Excel}

\item{auto_number_format}{Boolean. Whether to automatically detect number formats of columns}

\item{titles}{Character vector of titles. One element per row of title.}

\item{footers}{Table footers.  A character vector.  One element per row of footer.}

\item{left_header_colnames}{The names of the columns that you want to designate as left headers}

\item{vertical_border}{Boolean. Do you want a left border?}

\item{auto_open}{Boolean. Automatically open Excel output.}

\item{return_tab}{Boolean.  Return a tab object rather than a openxlsx workbook object}

\item{auto_merge}{Boolean.  Whether to merge cells in the title and footers to width of body}

\item{insert_below_tab}{A existing tab object.  If provided, this table will be written on the same sheet, below the provided tab.}
}
\description{
Take a data.frame in r and output an openxlsx wb object
}
\examples{
wb <- auto_crosstab_to_wb(mtcars)
}
