% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w.qqplot.R
\name{w.qqplot}
\alias{w.qqplot}
\title{W P-values Diagnosis by Q-Q Plot}
\usage{
w.qqplot(data, y, w.order = c(1, 2), input.poolsize = 200,
  hf1 = "default.hf1", hf2 = "default.hf2", ...)
}
\arguments{
\item{data}{a data frame or matrix containing genotypes in the columns. Genotypes should be coded as (0, 1, 2) or (0, 1).}

\item{y}{a numeric vector of 0 or 1, or a factor variable with two levels.}

\item{w.order}{a numeric number taking values 1 or 2. \code{w.order} = 1 gives main effect Q-Q plot. \code{w.order} = 2 gives interaction Q-Q plot.}

\item{input.poolsize}{a numeric number; The maximum number of SNPs to calculate the Q-Q plot. Default is 200. The \code{input.poolsize} is suggested to set as 1000 for \code{w.order} = 1, and 200 for \code{w.order} = 2.}

\item{hf1}{\emph{h} and \emph{f} values to calculate main effect, organized as a matrix, with columns (\emph{k}, \emph{h}, \emph{f}), \emph{k} = 2 to 3. Needed when \code{w.order} = 1.}

\item{hf2}{\emph{h} and \emph{f} values to calculate interaction associations, organized as a matrix, with columns (\emph{k}, \emph{h}, \emph{f}), \emph{k} = 2 to 9. Needed when \code{w.order} = 2.}

\item{...}{graphical parameters.}
}
\value{
Q-Q plot
}
\description{
Draw a Q-Q plot for W-test
}
\details{
With a given data and y, the p-value of W-test is calculated at given \emph{h} and \emph{f} values, which are plotted against the theoretical distribution.
}
\examples{
data(diabetes.geno)
data(phenotype1)
## Step 1. HF Calculation
# Please note that parameter B is recommended to be greater than 400.
hf1<-hf(data = diabetes.geno, w.order = 1, B = 200)

## Step 2. Q-Q Plot
w.qqplot(data = diabetes.geno, y = phenotype1, w.order = 1, hf1 = hf1, cex =.5)
abline(0,1)
}
