% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modularity.R
\name{modularity}
\alias{modularity}
\title{Modularity of a community structure of a graph}
\usage{
modularity(adj, membership, decomp = FALSE)
}
\arguments{
\item{adj}{An adjacency matrix, which should be symmetric with zeros on the diagonal.}

\item{membership}{Vector of length equal to the number of graph nodes (columns/rows 
of \code{adj}) indicating the cluster/sub-graph each nodes belongs to.}

\item{decomp}{Logical. If \code{TRUE}, calculate the decomposition of modularity
by modules and nodes. Default \code{FALSE}.}
}
\value{
\code{modularity} returns a list containing the following:
\item{totQ}{The total modularity. This is the only output if \code{decomp=FALSE}}
\item{modQ}{The contribution of each module to the total modularity}
\item{nodeQ}{The contribution of each node to the total modularity}
}
\description{
Computes the modularity of partitioning of a graph into sub-graphs. Similar to the
\code{modularity} function in the \code{igraph} package, but allows negative
edge weights.
}
\details{
The difference between this function and the function \code{modularity} 
in the package \code{igraph} is that this function can be used with an adjacency 
matrix with negative elements. This is a common case for matrices arrising from a 
for correlation matrix or another synchrony matrix. If the matrix is non-negative, 
the result of this function should be exactly the same as the result from 
\code{modularity} in the \code{igraph} package.
}
\note{
Adapted from code developed by Robert J. Fletcher, Jr.
}
\examples{
adj<-matrix(0, 10, 10) # create a fake adjacency matrix
adj[lower.tri(adj)]<-runif(10*9/2, -1, 1)
adj<-adj+t(adj)
colnames(adj)<-letters[1:10]
m<-cluseigen(adj)
z<-modularity(adj, m[[length(m)]], decomp=TRUE)

}
\references{
Fletcher Jr., R.J., et al. (2013) Network modularity reveals critical scales 
for connectivity in ecology and evolution. Nature Communications. doi: 10.1038//ncomms3572.

Gomez S., Jensen P. & Arenas A. (2009). Analysis of community structure in networks 
of correlated data. Phys Rev E, 80, 016114.

Newman M.E. (2006). Finding community structure in networks using the eigenvectors 
of matrices. Phys Rev E, 74, 036104.
}
\seealso{
\code{\link{clust}}, \code{\link{cluseigen}}, \code{browseVignettes("wsyn")}
}
\author{
Jonathan Walter, \email{jonathan.walter@ku.edu}; Lei Zhao, 
\email{lei.zhao@cau.edu.cn}; Daniel Reuman, \email{reuman@ku.edu}
}
