% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniques.R
\name{uniques}
\alias{uniques}
\title{Strict version of unique (without ...).}
\usage{
uniques(x, ..., incomparables = FALSE, MARGIN = 1, fromLast = FALSE)
}
\arguments{
\item{x}{items to be compared.}

\item{...}{not used, checked to be empty to prevent errors.}

\item{incomparables}{passed to base::unique.}

\item{MARGIN}{passed to base::unique.}

\item{fromLast}{passed to base::unique.}
}
\value{
base::unique(x, incomparables = incomparables, MARGIN = MARGIN, fromLast = fromLast)
}
\description{
Check that \code{...} is empty and if so call
\code{base::unique(x, incomparables = incomparables, MARGIN = MARGIN, fromLast = fromLast)}
(else throw an error)
}
\examples{

x = c("a", "b")
y = c("b", "c")

# task: get unique items in x plus y
unique(c(x, y))   # correct answer
unique(x, y)      # oops forgot to wrap arguments, quitely get wrong answer
tryCatch(
   uniques(x, y), # uniques catches the error
   error = function(e) { e })
uniques(c(x, y))  # uniques works like base::unique in most case

}
