% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convColorToTransp.R
\name{convColorToTransp}
\alias{convColorToTransp}
\title{Assign new transparency to given colors}
\usage{
convColorToTransp(color, alph = 1)
}
\arguments{
\item{color}{(character) color input}

\item{alph}{(numeric) transparency value (1 for no transparency, 0 for complete opaqueness), values <1 will be treated as percent-values}
}
\value{
character vector (of same length as input) with color encoding for new transparency
}
\description{
This function alows (re-)defining a new transparency. A color encoding vector will be transformed to the same color(s) but with new transparency (alpha).
}
\examples{
col0 <- c("#998FCC","#5AC3BA","#CBD34E","#FF7D73")
col1 <- convColorToTransp(col0,alph=0.7)
layout(1:2)
pie(rep(1,length(col0)),col=col0)
pie(rep(1,length(col1)),col=col1,main="new transparency")
}
\seealso{
\code{\link[grDevices]{rgb}}, \code{\link[graphics]{par}}
}
