% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceTable.R
\name{reduceTable}
\alias{reduceTable}
\title{Reduce table by aggregating smaller groups}
\usage{
reduceTable(tab, separFirst = 4, nGrp = 15)
}
\arguments{
\item{tab}{output of \code{\link[base]{table}}}

\item{separFirst}{(integer or NULL) optinal separartion of n 'separFirst' groups (value <2 or NULL 
will priviledge more uniform size of groups, higher values will cause small inital and larger tailing groups)}

\item{nGrp}{(integer) number of groups expected}
}
\value{
numeric vector with number of counts and class-borders as names (like table).
}
\description{
\code{reduceTable} treats/reduces results from \code{\link[base]{table}} to 'nGrp' groups, 
optional indiv resolution of 'separFirst' (numeric or NULL). 
Mainly made for reducing the number of classes for betters plots with \code{\link[graphics]{pie}}
}
\examples{
set.seed(2018); dat <- sample(11:60,200,repl=TRUE)
pie(table(dat))
pie(reduceTable(table(dat),sep=NULL))
pie(reduceTable(table(dat),sep=NULL),init.angle=90,clockwise=TRUE,col=rainbow(20)[1:15],cex=0.8) 
}
\seealso{
\code{\link[base]{table}}
}
