% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levIndex.R
\name{levIndex}
\alias{levIndex}
\title{transform (factor) levels into index}
\usage{
levIndex(dat, byOccurance = TRUE)
}
\arguments{
\item{dat}{(numeric or character vector or factor) main input}

\item{byOccurance}{(logical) toogle if lowest index should be based on alphabetical order or on order of input}
}
\value{
matrix with mean values
}
\description{
This function helps transforming a numeric or character vector into indexes of levels (of its original values).
By default indexes are assigned by order of occurance, ie, the first value of \code{x} will be get the index of 1.
Using the argument \code{byOccurance=FALSE} the resultant indexes will follow the sorted values.
}
\examples{
x1 <- letters[rep(c(5,2:3),1:3)]
levIndex(x1)
levIndex(x1, byOccurance=FALSE)
## with factor 
fa1 <- factor(letters[rep(c(5,2:3),1:3)], levels=letters[1:6])
levIndex(fa1)
levIndex(fa1, byOccurance=FALSE)
}
\seealso{
\code{\link{rowSds}}, \code{\link[base]{colSums}}
}
