% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeMatrices.R
\name{.mergeMatrices}
\alias{.mergeMatrices}
\title{Merge Multiple Matrices (main)}
\usage{
.mergeMatrices(
  inpL,
  mode = "intersect",
  useColumn = 1,
  extrRowNames = FALSE,
  na.rm = TRUE,
  argL = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{inpL}{(list containing matrices or data.frames) main input (multiple matrix or data.frame objects)}

\item{mode}{(character) allows choosing restricting to all common elements (\code{mode='intersect'}) or union  (\code{mode='union'})}

\item{useColumn}{(integer, character or list) the column(s) to consider, may be \code{'all'} to use all, integer to select specific indexes or list of indexes or colnames for cutom-selection per matrix}

\item{extrRowNames}{(logical) decide whether columns with all values different (ie no replicates or max divergency) should be excluded}

\item{na.rm}{(logical) suppress \code{NA}s}

\item{argL}{(list of arguments)}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a matrix containing all selected columns of the input matrices to fuse
}
\description{
This function allows merging of multiple matrix-like objects from an initial list.
}
\examples{
mat1 <- matrix(11:18, ncol=2, dimnames=list(letters[3:6],LETTERS[1:2]))
}
\seealso{
\code{\link{mergeMatrixList}},  \code{\link[base]{merge}},  \code{\link{mergeMatrices}} for separate entries
}
