setGeneric(
  name = "tsMake",
  def = function(object, ...)
    standardGeneric("tsMake")
)

setMethod(
  f = "tsMake",
  signature = "WqData",
  definition = function(object, focus, layer, type = c('ts.mon', 'zoo'),
    qprob = NULL)
  {
    require(reshape)
    require(zoo)

    ## Validate args
    if (missing(focus) || length(focus) > 1)
      stop("'focus' must be the name of a single site or single
      	variable.")
    type <- match.arg(type)

    ## Assemble all depths
    d <- as.data.frame(object)
    if (missing(layer)) layer = list(c(-Inf, Inf))
    if (length(layer) == 1) {
      if (layer == 'max.depths') {
          depth.code <- max(d$depth, na.rm=TRUE) + 1
          f <- function(x) subset(x, depth == max(depth, na.rm=TRUE))
          d <- ddply(d, c('time', 'site', 'variable'), f)
          d$depth <- depth.code
          layer <- depth.code
      }
    }
    if (!is.list(layer)) layer = list(layer)
    depths <- NULL
    for (el in layer) {
        if (length(el) > 1) {
            depths1 <- subset(d, depth >= el[1] & depth <= el[2])$depth
            depths <- c(depths, depths1)
        } else {
            depths <- c(depths, el)
        }
    }

    ## Define aggregation function
    if (is.null(qprob)) {
        f = mean
    } else {
        f = function(x, ...) quantile(x, probs = qprob, ...)
    }

    ## Reshape data
    if (match(focus, d$site, nomatch = 0) > 0) {
      d <- subset(d, depth %in% depths & site == focus)
      if (nrow(d) == 0) stop("No data for this site and layer.")
      c1 <- cast(d, time ~ variable, fun.aggregate = f, na.rm = TRUE)
    } else {
      if (match(focus, d$variable, nomatch = 0) > 0) {
        d <- subset(d, depth %in% depths & variable == focus)
        if (nrow(d) == 0) stop("No data for this variable and layer.")
        c1 <- cast(d, time ~ site, fun.aggregate = f, na.rm = TRUE)
      } else {
        stop("'focus' does not match any sites or variables")
      }
    }

    class(c1) <- "data.frame"  # necessitated by conflict with cast_df?
    z1 <- zoo(c1[, -1], c1[, 1])
    if (type == 'ts.mon') {
      z1 <- aggregate(z1, as.yearmon, f, na.rm = TRUE)
      if (is.null(nrow(z1)) || nrow(z1) > 1) z1 <- as.ts(z1)
    }
    z1
  }
)
