% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wm_attr_aphia.R
\name{wm_attr_aphia}
\alias{wm_attr_aphia}
\alias{wm_attr_aphia_}
\title{Get AphiaIDs by attribute definition ID}
\usage{
wm_attr_aphia(id, offset = 1, ...)

wm_attr_aphia_(id = NULL, name = NULL, ...)
}
\arguments{
\item{id}{(numeric/integer) a attribute ID. For \code{wm_attr_aphia} it's
required and must be \code{length(id) = 1}, for \code{wm_attr_aphia_} it's
optional and can be \code{length(id) >= 1}}

\item{offset}{(integer) record to start at. default: 1}

\item{...}{named curl options. see \code{\link[curl]{curl_options}}}

\item{name}{(character) one or more taxonomic names. optional}
}
\value{
A tibble/data.frame. when using underscore method, outputs from
each input are binded together, but can be split by \code{id} column
}
\description{
Get AphiaIDs by attribute definition ID
}
\section{Singular vs. plural}{

Of the two sister functions, the one without the underscore is the original
function that wraps the relavant WoRMS API method - and only accepts
one thing (i.e., name or AphiaID) per request.

The sister function with the underscore at the end is the plural version,
accepting more than one input. Internally this function loops over
the non-underscore method, and labels output (whether it's a list or
data.frame rows) with the input names or IDs so that you can easily
parse output by your inputs.
}

\examples{
\dontrun{
wm_attr_aphia(id = 7)
wm_attr_aphia(id = 4)
wm_attr_aphia(id = 4, offset = 50)

wm_attr_aphia_(id = c(7, 2))
}
}
