% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot.R
\name{textplot_terms}
\alias{textplot_terms}
\title{Plot coefficients of words}
\usage{
textplot_terms(
  x,
  highlighted = NULL,
  max_highlighted = 50,
  max_words = 1000,
  ...
)
}
\arguments{
\item{x}{a fitted textmodel_wordmap object.}

\item{highlighted}{\link[quanteda:pattern]{quanteda::pattern} to select words to highlight. If a
\link[quanteda:dictionary]{quanteda::dictionary} is passed, words in the top-level categories are
highlighted in different colors.}

\item{max_highlighted}{the maximum number of words to highlight. When
\code{highlighted = NULL}, words to highlight are randomly selected
proportionally to \code{coef ^ 2}.}

\item{max_words}{the maximum number of words to plot. Words are randomly
sampled to keep the number below the limit.}

\item{...}{passed to underlying functions. See the Details.}
}
\description{
Plot coefficients of words
}
\details{
Users can customize the plots through \code{...}, which is
passed to \code{\link[ggplot2:geom_text]{ggplot2::geom_text()}} and \code{\link[ggrepel:geom_text_repel]{ggrepel::geom_text_repel()}}. The
colors are specified internally but users can override the settings by appending
\code{\link[ggplot2:scale_manual]{ggplot2::scale_colour_manual()}} or \code{\link[ggplot2:scale_brewer]{ggplot2::scale_colour_brewer()}}. The
legend title can also be modified using \code{\link[ggplot2:labs]{ggplot2::labs()}}.
}
