% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{txt_clean_word2vec}
\alias{txt_clean_word2vec}
\title{Text cleaning specific for input to word2vec}
\usage{
txt_clean_word2vec(x, ascii = TRUE, alpha = TRUE, tolower = TRUE, trim = TRUE)
}
\arguments{
\item{x}{a character vector in UTF-8 encoding}

\item{ascii}{logical indicating to use \code{iconv} to convert the input from UTF-8 to ASCII. Defaults to TRUE.}

\item{alpha}{logical indicating to keep only alphanumeric characters. Defaults to TRUE.}

\item{tolower}{logical indicating to lowercase \code{x}. Defaults to TRUE.}

\item{trim}{logical indicating to trim leading/trailing white space. Defaults to TRUE.}
}
\value{
a character vector of the same length as \code{x} 
which is standardised by converting the encoding to ascii, lowercasing and 
keeping only alphanumeric elements
}
\description{
Standardise text by
\itemize{
\item{Conversion of text from UTF-8 to ASCII}
\item{Keeping only alphanumeric characters: letters and numbers}
\item{Removing multiple spaces}
\item{Removing leading/trailing spaces}
\item{Performing lowercasing}
}
}
\examples{
x <- c("  Just some.texts,  ok?", "123.456 and\tsome MORE!  ")
txt_clean_word2vec(x)
}
