% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest.R
\name{wkt_unnest}
\alias{wkt_unnest}
\alias{wkb_unnest}
\alias{wksxp_unnest}
\title{Flatten nested geometry structures}
\usage{
wkt_unnest(wkt, keep_empty = FALSE, keep_multi = TRUE, max_depth = 1)

wkb_unnest(wkb, keep_empty = FALSE, keep_multi = TRUE, max_depth = 1)

wksxp_unnest(wksxp, keep_empty = FALSE, keep_multi = TRUE, max_depth = 1)
}
\arguments{
\item{wkt}{A character vector containing well-known text.}

\item{keep_empty}{If \code{TRUE}, a GEOMETRYCOLLECTION EMPTY is left as-is
rather than collapsing to length 0.}

\item{keep_multi}{If \code{TRUE}, MULTI* geometries are not expanded to sub-features.}

\item{max_depth}{The maximum recursive GEOMETRYCOLLECTION depth to unnest.}

\item{wkb}{A \code{list()} of \code{\link[=raw]{raw()}} vectors, such as that
returned by \code{\link[sf:st_as_binary]{sf::st_as_binary()}}.}

\item{wksxp}{A \code{list()} of classed objects}
}
\value{
An unclassed vector with attribute \code{lengths}, which is an integer vector
with the same length as the input denoting the length to which each
feature was expanded.
}
\description{
Flatten nested geometry structures
}
\examples{
wkt_unnest("GEOMETRYCOLLECTION (POINT (1 2), POINT (3 4))")
wkt_unnest("GEOMETRYCOLLECTION EMPTY")
wkt_unnest("GEOMETRYCOLLECTION EMPTY", keep_empty = TRUE)

}
