% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makevars.R
\name{with_makevars}
\alias{with_makevars}
\title{Makevars variables}
\usage{
with_makevars(
  new,
  code,
  path = makevars_user(),
  assignment = c("=", ":=", "?=", "+=")
)
}
\arguments{
\item{new}{\verb{[named character]}\cr New variables and their values}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{path}{\verb{[character(1)]}\cr location of existing \code{Makevars} file to modify.}

\item{assignment}{\verb{[character(1)]}\cr assignment type to use.}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
argument.
}
\description{
Temporarily change contents of an existing \code{Makevars} file.
}
\details{
If no \code{Makevars} file exists or the fields in \code{new} do
not exist in the existing \code{Makevars} file then the fields are added to
the new file.  Existing fields which are not included in \code{new} are
appended unchanged.  Fields which exist in \code{Makevars} and in \code{new}
are modified to use the value in \code{new}.
}
\examples{
writeLines("void foo(int* bar) { *bar = 1; }\n", "foo.c")
system("R CMD SHLIB --preclean -c foo.c")
with_makevars(c(CFLAGS = "-O3"), system("R CMD SHLIB --preclean -c foo.c"))
unlink(c("foo.c", "foo.so"))
}
\seealso{
\code{\link{withr}} for examples
}
