% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estTWL.R, R/weightedLikelihood.R
\name{estTWL}
\alias{estTWL}
\alias{weightedLikelihood}
\title{Truncated Weighted Likelihood Estimation}
\usage{
estTWL(fatDist, fatW, distribution, plotBounds = NULL, ...)

weightedLikelihood(fatDist, fatW, distribution, plotBounds = NULL, ...)
}
\arguments{
\item{fatDist}{Vector of fatality distances from the turbine.}

\item{fatW}{Vector of weights, to weight the likelihood for estimatation. This must be the same length as fatDist and is assumed to be in the same order as fatDist.}

\item{distribution}{Character indicating the distribution for \code{weightedLikelihood} or vector for \code{estTWL}.}

\item{plotBounds}{Vector of length 1 or 2. If the length is 2 (or greater) the max value is used as the upper truncation bound and the min value is used as the lower truncation bound. If the length is 1 this value is taken as the upper truncation bound and zero is set as the lower truncation bound. The default is NULL, in which case the bounds are zero and positive infinity.}

\item{...}{Additional arguments passed to \code{\link[stats]{optim}}.}
}
\value{
Data frame of the parameter estimates for the distribution with fit statistics.
}
\description{
Maximum likelihood estimation of a (possibly truncated) probability density function is completed with weights on the likelihood.
}
\details{
The truncated likelihood for a single observation is
\deqn{L^*(\theta|x_i) = \frac{f(x_i|\theta)}{\int_{a}^{b}f(y|\theta)dy}}

Where \eqn{x_i} is \code{fatDist}, \eqn{\theta} is the vector of parameters to be estimated, \code{a} and \code{b} correspond to the \code{plotBounds} and \code{f()} is the \code{distribution} chosen.

The truncated weighted likelihood is
\deqn{TWL(\theta|\underbar{x}) = \prod_{i=1}^{n}L^*(\theta|x_i)^{w_i}}
Where \code{n=length(fatDist)} and \eqn{w_i} is \code{fatW}.

The truncated weighted likelihood is then estimated using standard maximum likelihood techniques.

See \code{\link{estTWL}} for examples.
}
\examples{
## load the data
data(carcassDistance)
data(proportionAreaSearched)

## add proportion of area searched to each carcass
carcDist <- merge(carcassDistance,proportionAreaSearched,
by=c('plotType','distanceFromTurbine'),all.x=TRUE)

## create the weight for each carcass
carcDist$w <- with(carcDist,1/(proportionAreaSearched*probabilityDetection))

twlOutput <- with(carcDist,estTWL(fatDist=distanceFromTurbine,fatW=w,plotBounds=c(0,100),
distribution=c('norm','weibull','gamma')))

}
\seealso{
\code{\link{calcAC}}
}
