% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hullMuirMaxDistance.R
\name{hullMuirMaxDistance}
\alias{hullMuirMaxDistance}
\title{Calculate the Hull and Muir (2010) maximum distance}
\usage{
hullMuirMaxDistance(hubHeight, bladeRadius, ...)
}
\arguments{
\item{hubHeight}{Numeric, turbine hub height.}

\item{bladeRadius}{Numeric, turbine blade radius.}

\item{...}{Currently ignored.}
}
\value{
data frame of maximum distance by size class, \code{hubHeight}, and
  \code{bladeRadius}. Distance will be in the same units as were provided for \code{hubHeight} and \code{bladeRadius}
}
\description{
Calculate the maximum fall distance from a turbine using the
  regression model from Hull and Muir (2010).
}
\details{
Using the linear regression coefficients from Hull and Muir (2010), a
  maximum distance is calculated. This is done for three size classes (bats,
  small birds (SB), and large birds (LB)) separately.

  It is assumed that \code{hubHeight} and \code{bladeRadius} have the same units.

Note: Hull and Muir (2010) used the range of 65 m < \code{hubHeight} < 94 m  and  33 m < \code{bladeRadius} < 55 m.
Anything outside of this range is extrapolation and should only be done with care.
}
\examples{

hubHeights <- rnorm(10, mean = 87.5, sd = 10)
bladeRadii <- rnorm(10, mean = 62.5, sd = 10)

hullMuirMaxDistance(hubHeight = hubHeights, bladeRadius = bladeRadii)
}
\references{
Hull, C. L., & Muir, S. (2010).
  Search areas for monitoring bird and bat carcasses at wind farms using a Monte-Carlo model.
  Australasian Journal of Environmental Management, 17(2), 77-87.
}
