% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_Property}
\alias{w_Property}
\title{Searching for properties of the entity list}
\usage{
w_Property(entity_list, Pproperty, langsorder = "en", nlimit = 10000)
}
\arguments{
\item{entity_list}{A vector with de Wikidata entities.}

\item{Pproperty}{Wikidata properties to search, separated with '|', mandatory.
For example, is Pproperty="P21", the results contain information of the sex
of entities. If Pproperty="P21|P569" also searches for birthdate. If
Pproperty='P21|P569|P214' also searches for VIAF identifier.}

\item{langsorder}{Order of languages in which the information will be
returned, separated with '|'. If no information is given in the first
language, next is used. This parameter is mandatory, at least one language is
required, default, 'en'}

\item{nlimit}{If the number of entities exceeds this number, chunked queries
are done. This is the number of entities requested in each chunk.}
}
\value{
A data-frame with 'entity', 'entityLabel', 'entityDescription' and,
additionally, the properties of Pproperty. Index of the data-frame is also
set to entity_list.
}
\description{
Search the entities of the entity_list for property or properties. Return the
properties in langsorder order. Duplicated entities are deleted before search.
}
\examples{
\dontrun{
l <- w_OccupationEntities(Qoc='Q2306091')
p <- w_Property(l, Pproperty = 'P21|P569|P214', langsorder = 'es|en')
}
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
