% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whitebox-package.R
\name{sample_dem_data}
\alias{sample_dem_data}
\alias{sample_soils_data}
\title{Convenience method for path to sample DEM and soils data}
\usage{
sample_dem_data(
  destfile = file.path(system.file("extdata", package = "whitebox"), "DEM.tif"),
  ...
)

sample_soils_data()
}
\arguments{
\item{destfile}{Path to target location of sample data. Will be downloaded if does not exist. Defaults to file path of extdata subfolder of whitebox package installation directory.}

\item{...}{additional arguments to download.file()}
}
\value{
character.
}
\description{
Get a file path to DEM.tif or STATSGO2.shp stored in extdata subfolder of whitebox package installation directory.
}
\examples{

if (check_whitebox_binary()) {
  wbt_slope(sample_dem_data(), output = "slope.tif")
}
unlink(c('slope.tif', 'settings.json'))
}
\keyword{General}
\keyword{datasets}
