% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_analysis.R
\name{wbt_image_slider}
\alias{wbt_image_slider}
\title{Image slider}
\usage{
wbt_image_slider(
  input1,
  input2,
  output,
  palette1 = "grey",
  reverse1 = FALSE,
  label1 = "",
  palette2 = "grey",
  reverse2 = FALSE,
  label2 = "",
  height = 600,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input1}{Name of the left input image file.}

\item{input2}{Name of the right input image file.}

\item{output}{Name of the output HTML file (*.html).}

\item{palette1}{Left image palette; options are 'grey', 'atlas', 'high_relief', 'arid', 'soft', 'muted', 'purple', 'viridi', 'gn_yl', 'pi_y_g', 'bl_yl_rd', 'deep', and 'rgb'.}

\item{reverse1}{Reverse left image palette?.}

\item{label1}{Left image label (leave blank for none).}

\item{palette2}{Right image palette; options are 'grey', 'atlas', 'high_relief', 'arid', 'soft', 'muted', 'purple', 'viridi', 'gn_yl', 'pi_y_g', 'bl_yl_rd', 'deep', and 'rgb'.}

\item{reverse2}{Reverse right image palette?.}

\item{label2}{Right image label (leave blank for none).}

\item{height}{Image height, in pixels.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool creates an image slider from two input images.
}
\keyword{ImageProcessingTools}
