% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_snap_pour_points}
\alias{wbt_snap_pour_points}
\title{Snap pour points}
\usage{
wbt_snap_pour_points(
  pour_pts,
  flow_accum,
  output,
  snap_dist,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{pour_pts}{Input vector pour points (outlet) file.}

\item{flow_accum}{Input raster D8 flow accumulation file.}

\item{output}{Output vector file.}

\item{snap_dist}{Maximum snap distance in map units.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Moves outlet points used to specify points of interest in a watershedding operation to the cell with the highest flow accumulation in its neighbourhood.
}
\keyword{HydrologicalAnalysis}
