% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whatr-data.R
\name{whatr_board}
\alias{whatr_board}
\title{What is the board?}
\format{A tibble with (usually) 61 rows and 4 variables:
\describe{
\item{round}{The round a clue is chosen.}
\item{col}{The column position left-to-right.}
\item{row}{The row position top-to-bottom.}
\item{n}{The order of clue chosen.}
\item{category}{Category title, often humorous or with instructions.}
\item{clue}{The clue read to the contestants.}
\item{answer}{The \emph{correct} answer to a clue.}
}}
\usage{
whatr_board(game)
}
\arguments{
\item{game}{One of four types of input, all passed to \code{\link[=whatr_html]{whatr_html()}}:
\enumerate{
\item A numeric game ID.
\item Either a 'showgame' or 'showscores' HTML document.
\item A show number character starting with "#".
\item An air date like "yyyy-mm-dd".
}}
}
\value{
A tidy tibble of clue text.
}
\description{
\emph{This} grid contains all the categories, clues, and answers in a game.
}
\examples{
whatr_board(game = 6304)
}
